﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using static ClickSilimulation.HotKey;

namespace ClickSilimulation
{
    public static class Extends
    {
        public static KeyModifiers GetKeyModifiers(this ComboBox comboBox)
        {
            try
            {
                KeyModifiers value;
                Enum.TryParse(comboBox.SelectedItem.ToString(), out value);
                return value;
            }
            catch (Exception)
            {
                return KeyModifiers.None;
            }
        }

        public static Keys GetKeys(this ComboBox comboBox)
        {
            try
            {
                Keys value;
                Enum.TryParse(comboBox.SelectedItem.ToString(), out value);
                return value;
            }
            catch (Exception)
            {
                return Keys.None;
            }
        }

        public static int GetIntValue(this TextBox textBox, int defaultValue)
        {
            try
            {
                int value;
                Int32.TryParse(textBox.Text, out value);
                return value == 0 ? defaultValue : value;
            }
            catch (Exception)
            {
                return defaultValue;
            }
        }

        //public static void Add(this List<SilimulationEvent> silimulationEvents, ComboBox comboBoxFK, ComboBox comboBoxSK, TextBox txtStartTime, TextBox txtEndTime)
        //{
        //    if (silimulationEvents == null)
        //    {
        //        return;
        //    }

        //    var keyModifiers = comboBoxFK.GetKeyModifiers();
        //    var keys = comboBoxSK.GetKeys();

        //    if (keys == Keys.None)
        //    {
        //        return;
        //    }

        //    silimulationEvents.Add(new SilimulationEvent()
        //    {
        //        FirstKey = keyModifiers,
        //        SecondKey = keys,
        //        IntervalTimeMin = txtStartTime.GetIntValue(50),
        //        IntervalTimeMax = txtEndTime.GetIntValue(200),
        //    });
        //}
    }
}
